

/* touch panel interface define */
sbit SDA	   =    P3^0;
sbit SCL       =    P3^1;
sbit PEN_INT       =    P3^2;	
sbit RESET	   =	P3^3;


#define uchar      unsigned char
#define uint       unsigned int
#define ulong      unsigned long

#define WHITE          0xFFFF
#define BLACK          0x0000
#define GRAY           0xF7DE
#define BLUE           0x001F
#define BLUE2          0x051F
#define RED            0xF800
#define PURPLE         0xF81F
#define GREEN          0x07E0
#define CYAN           0x7FFF
#define YELLOW         0xFFE0
#define DGREEN         0x07E0

#define CONFIG_FT5X0X_MULTITOUCH    //Define the multi-touch
//Touch Status	 
#define Key_Down 0x01
#define Key_Up   0x00 

struct _ts_event
{
    uint    x1;
    uint    y1;
    uint    x2;
    uint    y2;
    uint    x3;
    uint    y3;
    uint    x4;
    uint    y4;
    uint    x5;
    uint    y5;
    uchar     touch_point;
	uchar     Key_Sta;	
};

struct _ts_event ts_event; 


#define WRITE_ADD	0xba 
#define READ_ADD	0xbb

#define CT_MAX_TOUCH    5 	//ݴֵ֧ĵ

// Registers define
#define GTP_READ_COOR_ADDR    0x814e
#define GTP_REG_SLEEP         0x8040
#define GTP_REG_SENSOR_ID     0x814a
#define GTP_REG_CONFIG_DATA   0x8047
#define GTP_REG_VERSION       0x8440



 uchar code GTP_CFG_DATA[]=
{ 	  
0x5A,0x20,0x03,0xE0,0x01,0x05,0x0D,0x00,
0x01,0x08,0x28,0x08,0x50,0x32,0x03,0x05,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x88,0x29,0x0A,0x35,0x37,
0xD3,0x07,0x00,0x00,0x01,0x81,0x02,0x1D,
0x00,0x01,0x00,0x00,0x00,0x03,0x64,0x32,
0x00,0x00,0x00,0x28,0x5A,0x94,0xC5,0x02,
0x00,0x00,0x00,0x00,0x98,0x2B,0x00,0x84,
0x33,0x00,0x74,0x3C,0x00,0x67,0x46,0x00,
0x5C,0x53,0x00,0x5C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x10,
0x12,0x14,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
0x04,0x06,0x08,0x0F,0x10,0x12,0x16,0x18,
0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x25,0x01	
/*	 
0x41,0x20,0x03,0xE0,0x01,0x0A,0x0D,0x00,
0x01,0x08,0x28,0x05,0x50,0x32,0x03,0x05,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x8A,0x2A,0x0C,0x17,0x15,
0x31,0x0D,0x00,0x00,0x01,0xBB,0x03,0x2D,
0x00,0x00,0x00,0x00,0x00,0x03,0x64,0x32,
0x00,0x00,0x00,0x0F,0x94,0x94,0xC5,0x02,
0x07,0x00,0x00,0x04,0x8D,0x13,0x00,0x5C,
0x1E,0x00,0x3C,0x30,0x00,0x29,0x4C,0x00,
0x1E,0x78,0x00,0x1E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x10,
0x12,0x14,0x16,0x18,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
0x04,0x06,0x08,0x0A,0x0F,0x10,0x12,0x13,
0x16,0x18,0x1C,0x1D,0x1E,0x1F,0x20,0x21,
0x22,0x24,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x5C,0x01  */
};


void TOUCH_Init(void);
void TOUCH_Start(void);
void TOUCH_Stop(void);
uchar   TOUCH_Wait_Ack(void);
void TOUCH_Ack(void);
void TOUCH_NAck(void);

void TOUCH_Send_Byte(uchar txd);
uchar TOUCH_Read_Byte(unsigned char ack);
void Draw_Big_Point(uint x,uint y,uint colour);
uchar GT911_read_data(void);
void inttostr(uint value,uchar *str);


//IIC start
void TOUCH_Start(void)
{ 
	SDA=1;  
	_nop_();
	SCL=1;
	delayus(3);
	SDA=0;  
	delayus(3);
	SCL=0;
//	delayus(1);
}	  


//IIC stop
void TOUCH_Stop(void)
{
	SDA=0;
	_nop_();
	SCL=1;
	delayus(3);
	SDA=1;
	delayus(3);
	SCL=0;
//	delayus(1);						   	
}


//Wait for an answer signal
uchar TOUCH_Wait_Ack(void)
{	uchar errtime=0;

	SDA=1;
//	delayus(1);
	SCL=1;
//	delayus(1);
  	while(SDA)
	{
	    errtime++;
	    if(errtime>250)
		    {
		      TOUCH_Stop();
		      return 1;
		    }	
	
	   ;
	}
	SCL=0;
//	delayus(1);
	return 0;
}



//Acknowledge
void TOUCH_Ack(void)
{	SCL=0;
	_nop_();
	SDA=0;
	delayus(2);
	SCL=1;
	delayus(2);
	SCL=0;
	_nop_();
}



//NO Acknowledge		    
void TOUCH_NAck(void)
{	SCL=0;
	delayus(1);
	SDA=1;
	delayus(2);
	SCL=1;
	delayus(2);
	SCL=0;
	_nop_();
}	
	

//IIC send one byte		  
void TOUCH_Send_Byte(uchar Byte)
{	uchar t;  		
 	SCL=0; 
//	delayus(5);
    for(t=0;t<8;t++)
    {           
	   	SDA=(bit)(Byte & 0x80) ;
	   	Byte <<=1;
		delayus(2);
	   	SCL=1;
		delayus(2);
	   	SCL=0;
	//	delayus(5);
    }	

} 

//Read one byteack=0Send Acknowledgeack=1NO Acknowledge   
uchar TOUCH_Read_Byte(uchar ack)
{	uchar t,receive=0;

	SCL=0;
//	delayus(5);
	SDA=1;
//	delayus(5);
	for(t = 0; t < 8; t++)
	{	_nop_();
	 	SCL = 0;
		delayus(4);
	 	SCL=1;
		delayus(4);
	 	receive<<=1;
	 	if(SDA)receive=receive|0x01;
	//	delayus(5);
	}

					 
   	if (ack)  TOUCH_NAck();//NO Acknowledge 
   	else       TOUCH_Ack(); //Send Acknowledge   
    
	 return receive;
}

uchar GT911_WR_Reg(uint reg,uchar *buf,uchar len)
{
	uchar i;
	uchar ret=0;
	TOUCH_Start();	
 	TOUCH_Send_Byte(WRITE_ADD);   	//д 	 
	TOUCH_Wait_Ack();
	TOUCH_Send_Byte(reg>>8);   	//͸8λַ
	TOUCH_Wait_Ack();	 										  		   
	TOUCH_Send_Byte(reg&0XFF);   	//͵8λַ
	TOUCH_Wait_Ack(); 
	for(i=0;i<len;i++)
	{	   
    	TOUCH_Send_Byte(buf[i]);  	//
		ret=TOUCH_Wait_Ack();
		if(ret)break;  
	}
    TOUCH_Stop();					//һֹͣ	    
	return ret; 
}


void GT911_RD_Reg(uint reg,uchar *buf,uchar len)
{
	uchar i;
 	TOUCH_Start();	
 	TOUCH_Send_Byte(WRITE_ADD);   	//д 	 
	TOUCH_Wait_Ack(); 
 	TOUCH_Send_Byte(reg>>8);   	//͸8λַ
	TOUCH_Wait_Ack();  										  		   
 	TOUCH_Send_Byte(reg&0XFF);   	//͵8λַ
	TOUCH_Wait_Ack();
  
 	TOUCH_Start(); 	 	   
	TOUCH_Send_Byte(READ_ADD);    //Ͷ		   
	TOUCH_Wait_Ack();    
	for(i=0;i<len;i++)
	{	   
    	buf[i]=TOUCH_Read_Byte(i==(len-1)?1:0); //
		
		
	//	if(i==(len-1))  buf[i]=TOUCH_Read_Byte(1);
	//	else            buf[i]=TOUCH_Read_Byte(0);	 
		
	} 
     TOUCH_Stop();//һֹͣ	    
}

uchar GT911_Send_Cfg(uchar * buf,uint cfg_len)
{
	uchar ret=0;
	uchar retry=0;
	for(retry=0;retry<5;retry++)
	{
		ret=GT911_WR_Reg(GTP_REG_CONFIG_DATA,buf,cfg_len);
		if(ret==0)break;
		delay(10);	 
	}
	return ret;
}


/******************************************************************************************
*Function nameDraw_Big_Point(u16 x,u16 y)
* Parameteruint16_t x,uint16_t y xy
* Return Valuevoid
* FunctionDraw touch pen nib point 3 * 3
*********************************************************************************************/		   
void Draw_Big_Point(uint x,uint y,uint colour)
{uint num;	    
	
	LCD_SetPos(x-1,x+1,y-1,y+1);
	    for(num=0;num<9;num++)
		{    
          	Write_Data_int(colour);
		}
}


uchar GT911_read_data(void)
{	uchar buf[50] = {0xff}; uchar ret = 0;	uchar ss[4];


	GT911_RD_Reg(GTP_READ_COOR_ADDR,buf,50);		

	ss[0]=0;		
 	GT911_WR_Reg(GTP_READ_COOR_ADDR,ss,1);	  //Must clear  Buffer status
  
  	ts_event.touch_point = buf[0] & 0x0f;


  /*		FontWrite_Position(20,60);
		String("touch_point=");


 		inttostr(ts_event.touch_point ,ss);
		  LCD_CmdWrite(0x02);
		LCD_DataWrite(ss[0]);	delayus(2);	
		LCD_DataWrite(ss[1]);	delayus(2);
		LCD_DataWrite(ss[2]);	delayus(2);
		LCD_DataWrite(ss[3]);	delayus(2);	 */

  	if (ts_event.touch_point == 0) 
		{  			

			return 0;
  		}		
   

					switch (ts_event.touch_point) 
					{
 						
							case 5:
				           			ts_event.x5 = (uint)(buf[35] )<<8 | (uint)buf[34];
				           			ts_event.y5 = (uint)(buf[37] )<<8 | (uint)buf[36];
				
						    case 4:
						           	ts_event.x4 = (uint)(buf[27] )<<8 | (uint)buf[26];
						           	ts_event.y4 = (uint)(buf[29] )<<8 | (uint)buf[28];
						
						    case 3:
						           	ts_event.x3 = (uint)(buf[19] )<<8 | (uint)buf[18];
						           	ts_event.y3 = (uint)(buf[21] )<<8 | (uint)buf[20];
						
						    case 2:
						           	ts_event.x2 = (uint)(buf[11] )<<8 | (uint)buf[10];
						           	ts_event.y2 = (uint)(buf[13] )<<8 | (uint)buf[12];
						
						    case 1:
						           	ts_event.x1 = (uint)(buf[3] )<<8 | (uint)buf[2];
						           	ts_event.y1 = (uint)(buf[5] )<<8 | (uint)buf[4];
				
				    break;
						    default:
						    return 0;
					}


	   
	return ret;
}


void inttostr(uint value,uchar *str)
{
	str[0]=value/1000+48;
	str[1]=value%1000/100+48;
	str[2]=value%1000%100/10+48;
 	str[3]=value%1000%100%10+48;
}



void TOUCH_Init(void)
{	
	/*	RESET=0;
		PEN_INT=0;
		Delay1ms(30);
 		PEN_INT=1;
		Delay1ms(5);
		RESET=1;;
		Delay1ms(20);
		ACC=PEN_INT;
		ACC=PEN_INT;
 		Delay1ms(200);	 */

 		RESET=0;						   
		PEN_INT=0;
		delay(20);
 		RESET=1;
		delay(500);
		ACC=PEN_INT;
 		ACC=PEN_INT;
 		delay(200);

		ts_event.x1=0;
		ts_event.y1=0;
		ts_event.x2=0;
		ts_event.y2=0;
		ts_event.x3=0;
		ts_event.y3=0;
		ts_event.x4=0;
		ts_event.y4=0;
		ts_event.x5=0;
		ts_event.y5=0;

	   
}						  





//show one Character
void showzifu(unsigned int x,unsigned int y,unsigned char value,unsigned int dcolor,unsigned int bgcolor)	
{  
	unsigned char i,j;
	unsigned char *temp=zifu;    
    LCD_SetPos(x,x+7,y,y+11); //Settings area      
	temp+=(value-32)*12;
	for(j=0;j<12;j++)
	{
		for(i=0;i<8;i++)
		{ 		     
		 	if((*temp&(1<<(7-i)))!=0)
			{
				Write_Data_byte(dcolor>>8,dcolor);
			} 
			else
			{
				Write_Data_byte(bgcolor>>8,bgcolor);
			}   
		}
		temp++;
	 }
}

//show one Character
void showzifustr(unsigned int x,unsigned int y,unsigned char *str,unsigned int dcolor,unsigned int bgcolor)	  
{  
	unsigned int x1,y1;
	x1=x;
	y1=y;
	while(*str!='\0')
	{	
		showzifu(x1,y1,*str,dcolor,bgcolor);
		x1+=7;
		str++;
	}	
}




void TPTEST(void)
{
	uchar ss[4]; uchar re=1;//	uchar i;  uchar bb[187];

	 TOUCH_Init();

 	LCD_clear(0x00);				
    showzifustr(30,5,"HELLOW!PLEASE TOUCH ME!  Welcome used 7 inch TFT LCD module",RED,WHITE);	
    showzifustr(80,18,"TP TEST!",BLACK,RED);

			re=GT911_Send_Cfg((uchar*)GTP_CFG_DATA,sizeof(GTP_CFG_DATA));
			if(re==0)
			showzifustr(30,110,"send CFG OK",BLACK,RED);
	 		else  showzifustr(30,110,"send CFG NOK",BLACK,RED);

	while(KEY)
	{
		
	  	 GT911_RD_Reg(GTP_READ_COOR_ADDR,ss,1);

	   	if(ss[0]&0x80)
				{	


					GT911_read_data();
					ts_event.Key_Sta=Key_Up;
					ss[0]=0;		
 					GT911_WR_Reg(GTP_READ_COOR_ADDR,ss,1);	  //Must clear  Buffer status	
						
					inttostr(ts_event.x1,ss);
					showzifustr(10,205,"X1:",BLUE,WHITE);
					showzifustr(35,205,ss,RED,WHITE);	
					inttostr(ts_event.y1,ss);
					showzifustr(80,205,"Y1:",BLUE,WHITE);
					showzifustr(105,205,ss,RED,WHITE);	

					Draw_Big_Point(ts_event.x1,ts_event.y1,RED);
					Draw_Big_Point(ts_event.x2,ts_event.y2,GREEN);	
					Draw_Big_Point(ts_event.x3,ts_event.y3,BLUE);
					Draw_Big_Point(ts_event.x4,ts_event.y4,CYAN);	
					Draw_Big_Point(ts_event.x5,ts_event.y5,PURPLE);

                     
				}
			
			


    }



}












